//
//  Chap2.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/04/01.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap2_h
#define Chap2_h
/*------------------------------------------------*/
/*［２］関数変換　　　　　　　　　　　　　　　　　　　　　 　*/
/*------------------------------------------------*/
//割線法による生存関数の逆関数
double SecantHayter(double (*f)(double,int,int),int k,int m,double al){
    /*Hayter型分布関数f(doube,int,int)の方程式f(x,k,m)=1-alをxについて解く割線法*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*幅1の区間[t0,t1]に解を囲い込む*/
    t1=0;f1=f(t1,k,m)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,m)-1+al;
    }
    /*幅1/64の区間[t0,t1]に解を囲い込む:二分法*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,m)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*割線法で精度を上げる*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,m)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,m)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantDunnettB(double (*f)(double,int,double*),int k,double *lms,double al){
    /*Dunnett B型分布関数f(double,int,double*)の方程式f(x,k,lms)=1-alをxについて解く割線法*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*幅1の区間[t0,t1]に解を囲い込む*/
    t1=0;f1=f(t1,k,lms)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,lms)-1+al;
    }
    /*幅1/64の区間[t0,t1]に解を囲い込む:二分法*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,lms)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*割線法で精度を上げる*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,lms)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,lms)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantDunnettTB(double (*f)(double,int,int*),int k,int *ns,double al){
    /*Dunnett TB分布関数f(double,int,int*)の方程式f(x,k,ns)=1-alをxについて解く割線法*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*幅1の区間[t0,t1]に解を囲い込む*/
    t1=0;f1=f(t1,k,ns)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,ns)-1+al;
    }
    /*幅1/64の区間[t0,t1]に解を囲い込む:二分法*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,ns)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*割線法で精度を上げる*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,ns)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,ns)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double Secantt(double (*f)(double,int),int k,double al){
    /*t分布型分布関数f(double,int)の方程式f(x,k)=1-alをxについて解く割線法*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*幅1の区間[t0,t1]に解を囲い込む*/
    t1=0;f1=f(t1,k)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k)-1+al;
    }
    /*幅1/64の区間[t0,t1]に解を囲い込む:二分法*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*割線法で精度を上げる*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantNormalB(double (*f)(double,int,double*,int),int k,double *lms,int m,double al){
    /*Normal B型分布関数f(t,int,double*,int)の方程式f(x,k)=1-alをxについて解く割線法*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*幅1の区間[t0,t1]に解を囲い込む*/
    t1=0;f1=f(t1,k,lms,m)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,lms,m)-1+al;
    }
    /*幅1/64の区間[t0,t1]に解を囲い込む:二分法*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,lms,m)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*割線法で精度を上げる*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,lms,m)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,lms,m)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantNormalC(double (*f)(double,int,double*),int k,double *lms,double al){
    /*Normal C型分布関数f(t,int,double*)の方程式f(x,k)=1-alをxについて解く割線法*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*幅1の区間[t0,t1]に解を囲い込む*/
    t1=0;f1=f(t1,k,lms)-1+al;
    cnt=0;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,lms)-1+al;
        cnt++;
    }
    /*幅1/64の区間[t0,t1]に解を囲い込む:二分法*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,lms)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*割線法で精度を上げる*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,lms)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,lms)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};

//分布関数f(t)からF(t)=\int_0^∞ f(st)g(s|m)ds への積分変換(DE積分則)
double psm1(double x){/* = ψ(x)-1：ψ(x)はDE変換関数*/
    return expm1(x - expm1(-x));
};
double ps1(double x){/* = ψ'(x)：DE変換関数ψ(x)の導関数*/
    return (1+exp(-x))*exp(x - expm1(-x));
};
double chiHayterFun(double x,double (*f)(double,int),double t,int k,int m){
    /*Hayter型分布関数f(doube,int,int)に対する被積分関数*/
    double sm;
    sm = sqrt((double) m);
    return f(t*(1+psm1(x/sm)),k)*g1PDF(psm1(x/sm),m)*ps1(x/sm)/sm;
};
double chiIntegralHayter(double (*f)(double,int),double t,int k,int m){
    /*Hayter型分布関数f(doube,int,int)に対する積分変換(DE積分則)*/
    double S,h,eps,term;
    int i;
    /*台形則*/
    h = 0.1;
    eps = 1.0e-16;
    S = chiHayterFun(0,f,t,k,m);
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiHayterFun(i*h,f,t,k,m);
        S += term;
        i++;
    };
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiHayterFun(-i*h,f,t,k,m);
        S += term;
        i++;
    };
    return(h*S);
};
double chiDunnettFun(double x,double (*f)(double,int,double*),double t,int k,double *lms,int m){
    /*Dunnett型分布関数f(doube,int,double*)に対する積分変換(DE積分則)*/
    double sm;
    sm = sqrt((double) m);
    return f(t*(1+psm1(x/sm)),k,lms)*g1PDF(psm1(x/sm),m)*ps1(x/sm)/sm;
};
double chiIntegralDunnett(double (*f)(double,int,double*),double t,int k,double *lms,int m){
    /*Dunnet型関数D(x,k,lms)からTD(x,k,ns)を生成する積分変換(DE積分則),m=Sum(ns[i],{i,0,k-1})*/
    double S,h,eps,term;
    int i;
    /*台形則*/
    h = 0.1;
    eps = 1.0e-16;
    S = chiDunnettFun(0,f,t,k,lms,m);
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiDunnettFun(i*h,f,t,k,lms,m);
        S += term;
        i++;
    };
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiDunnettFun(-i*h,f,t,k,lms,m);;
        S += term;
        i++;
    };
    return(h*S);
};
#endif /* Chap2_h */
